using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
    public partial class INTERPRETATION_LETTERDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors

        public INTERPRETATION_LETTERDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public INTERPRETATION_LETTER GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 INTERPRETATION_LETTER_ID)
        {
            INTERPRETATION_LETTER objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_INTERPRETATION_LETTER_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, INTERPRETATION_LETTER_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<INTERPRETATION_LETTER> GetItemsByWkfCaseActivityId(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ACTIVITY_ID)
        {
            List<INTERPRETATION_LETTER> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_INTERPRETATION_LETTER_getitemsByWkfCaseActivityId(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<INTERPRETATION_LETTER> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<INTERPRETATION_LETTER> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_INTERPRETATION_LETTER_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<INTERPRETATION_LETTER> GetItemsInPrintQueueForWkfCaseTypeId(string CURRENT_USER, int CURRENT_REGISTRY_ID, int STD_WKFCASETYPE_ID)
        {
            List<INTERPRETATION_LETTER> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_INTERPRETATION_LETTER_getItemsInPrintQueueForWkfCaseTypeId(CURRENT_USER, CURRENT_REGISTRY_ID, STD_WKFCASETYPE_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<Letter> GetPatientLetterContent(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ACTIVITY_ID)
        {
            List<Letter> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_GetPatientLetterContent(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<Letter> GetProviderLetterContent(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ACTIVITY_ID)
        {
            List<Letter> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_GetProviderLetterContent(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, INTERPRETATION_LETTER objSave)
        {
            Int32? objReturn = objSave.INTERPRETATION_LETTER_ID;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_INTERPRETATION_LETTER_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.CCAddress, DateTime.Now, objSave.CREATEDBY, objSave.FROM_ADDRESS, ref objReturn, objSave.Letter_SUBJECT, objSave.PATIENT_ADDR1, objSave.PATIENT_ADDR2, objSave.PATIENT_ADDR3, objSave.PATIENT_CITY, objSave.PATIENT_COMMENT, objSave.PATIENT_COUNTRY, objSave.PATIENT_INTERPRETATION_TEXT, objSave.PATIENT_NAME, objSave.PATIENT_PHONE, objSave.PATIENT_POSTAL, objSave.PATIENT_STATE, objSave.PATIENT_ZIPPLUS4, objSave.PRINT_QUEUE, objSave.PROVIDER_ADDR1, objSave.PROVIDER_ADDR2, objSave.PROVIDER_ADDR3, objSave.PROVIDER_CITY, objSave.PROVIDER_COMMENTS, objSave.PROVIDER_COUNTRY, objSave.PROVIDER_INSTITUTION_NAME, objSave.PROVIDER_INTERPRETATION_TEXT, objSave.PROVIDER_NAME, objSave.PROVIDER_PHONE, objSave.PROVIDER_POSTAL, objSave.PROVIDER_STATE, objSave.PROVIDER_ZIPPLUS4, objSave.STD_SIGNING_CLINICIAN_ID, DateTime.Now, objSave.UPDATEDBY, objSave.WKF_CASE_ACTIVITY_ID);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 INTERPRETATION_LETTER_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_INTERPRETATION_LETTER_delete(CURRENT_USER, CURRENT_REGISTRY_ID, INTERPRETATION_LETTER_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public Boolean DeleteByActivity(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ACTIVITY_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_INTERPRETATION_LETTER_deleteByActivity(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        #endregion
    }
}
